<?php $__env->startSection('title'); ?>
    <?php echo e(ucfirst(Request::get('view')), false); ?>

    <?php echo e(trans_choice('accounting::general.budget', 1), false); ?> - <?php echo e($financial_year, false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(ucfirst(Request::get('view')), false); ?>

            <?php echo e(trans_choice('accounting::general.budget', 1), false); ?> - <?php echo e($financial_year, false); ?>

        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">
        <div class="row">
            <?php $__env->startComponent('accounting::components.box'); ?>
                <?php $__env->slot('header'); ?>
                    <div class="box-tools">
                        <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#settingsModal">
                            <i class="fas fa-cog"></i>
                        </button>
                    </div>

                    <div class="col-md-4">
                        <form action="<?php echo e(Request::url(), false); ?>" id="financial_year_form">
                            <input type="hidden" name="view" value="<?php echo e(Request::get('view'), false); ?>">
                            <div class="form-group">
                                <label for="year"><?php echo e(trans_choice('accounting::general.financial_year', 1), false); ?></label>
                                <input type="text" class="form-control year-datepicker" name="year" id="financial_year" v-model="financial_year">
                            </div>
                        </form>
                    </div>
                <?php $__env->endSlot(); ?>

                <?php $__env->slot('body'); ?>
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs nav-justified">
                            <li class="<?php if(Request::get('view') == 'monthly'): ?> active <?php endif; ?>">
                                <a href="<?php echo e(request()->view != 'monthly' ? $url->monthly : '#', false); ?>" aria-expanded="true">
                                    <i class="fas fa-calendar" aria-hidden="true"></i>
                                    <?php echo e(trans_choice('accounting::lang.monthly', 1), false); ?>

                                </a>
                            </li>
                            <li class="<?php if(Request::get('view') == 'quarterly'): ?> active <?php endif; ?>">
                                <a href="<?php echo e(request()->view != 'quarterly' ? $url->quarterly : '#', false); ?>" aria-expanded="true">
                                    <i class="fas fa-calendar" aria-hidden="true"></i>
                                    <?php echo e(trans_choice('accounting::lang.quarterly', 1), false); ?>

                                </a>
                            </li>
                            <li class="<?php if(Request::get('view') == 'yearly'): ?> active <?php endif; ?>">
                                <a href="<?php echo e(request()->view != 'yearly' ? $url->yearly : '#', false); ?>" aria-expanded="true">
                                    <i class="fas fa-calendar" aria-hidden="true"></i>
                                    <?php echo e(trans_choice('accounting::lang.yearly', 2), false); ?>

                                </a>
                            </li>
                        </ul>

                        <div class="tab-content">
                            <div class="tab-pane active">

                                

                                <?php if(!empty($chart_of_accounts) && count($chart_of_accounts) > 0): ?>
                                    <?php switch(Request::get('view')):
                                        case ('monthly'): ?>
                                            <?php echo $__env->make('accounting::budget.partials.monthly_view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php break; ?>

                                        <?php case ('quarterly'): ?>
                                            <?php echo $__env->make('accounting::budget.partials.quarterly_view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php break; ?>

                                        <?php case ('yearly'): ?>
                                            <?php echo $__env->make('accounting::budget.partials.yearly_view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        <?php break; ?>

                                        <?php default: ?>
                                            <div class="alert alert-info text-center">
                                                <?php echo e(trans('accounting::lang.an_error_occurred'), false); ?>

                                            </div>
                                    <?php endswitch; ?>
                                <?php else: ?>
                                    <div class="alert alert-info text-center">
                                        <?php echo e(trans('accounting::lang.chart_of_account_needed_to_budget'), false); ?>

                                        <?php echo e(trans('accounting::lang.add'), false); ?>

                                        <a href="<?php echo e(url('accounting/chart_of_account/create'), false); ?>">
                                            <?php echo e(trans('accounting::lang.here'), false); ?>

                                        </a>
                                    </div>
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>

                    <?php echo $__env->make('accounting::budget.modals.budget_settings_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <?php $__env->endSlot(); ?>
            <?php echo $__env->renderComponent(); ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('javascript'); ?>
    <script>
        $(function() {
            $('.apply_for_all').on('click', function() {
                const id = $(this).attr('input_id')
                const value = $('#' + id).val();
                const view = "<?php echo e(Request::get('view'), false); ?>";

                switch (view) {
                    case 'monthly':
                        $("[id^=month_]").val(value);
                        break;

                    case 'quarterly':
                        $("[id^=quarter_]").val(value);
                        break;

                    default:
                        break;
                }

            });

            $('#financial_year').on('change', function() {
                document.getElementById('financial_year_form').submit();
            })
        })

        new Vue({
            el: '#vue-app',
            data() {
                return {
                    financial_year_start: "<?php echo e($financial_year_start, false); ?>",
                    financial_year: "<?php echo e($financial_year, false); ?>",
                    business_id: "<?php echo e(session('business.id'), false); ?>",
                    view: "<?php echo e(Request::get('view'), false); ?>",
                    chart_of_account_id: '',
                    chart_of_accounts: <?php echo json_encode($chart_of_accounts); ?>,
                    months: [],
                    quarters: [],
                    yearly_budget: 0,
                    eliminate_decimals: true
                }
            },

            computed: {
                chart_of_account() {
                    const chart_of_account = this.chart_of_accounts.find(account => account.id == this.chart_of_account_id);
                    const default_chart_of_account = {
                        name: ''
                    };

                    return chart_of_account ?
                        chart_of_account :
                        default_chart_of_account;
                }
            },

            methods: {
                onClickEditBudget(e) {
                    this.chart_of_account_id = e.target.getAttribute('chart_of_account_id');

                    switch (this.view) {
                        case 'monthly':
                            !this.chart_of_account || this.chart_of_account.budget == null ?
                                this.setMonthlyBudget({}) :
                                this.setMonthlyBudget(this.chart_of_account.budget);
                            break;

                        case 'quarterly':
                            !this.chart_of_account || this.chart_of_account.budget == null ?
                                this.setQuarterlyBudget({}) :
                                this.setQuarterlyBudget(this.chart_of_account.budget);
                            break;

                        case 'yearly':
                            this.yearly_budget = !this.chart_of_account || this.chart_of_account.budget == null ?
                                0 :
                                this.chart_of_account.budget.yearly;
                            break;

                        default:
                            throw 'No view type found'
                            break;
                    }
                },

                setMonthlyBudget(budget) {
                    if (!Object.keys(budget).length > 0) {
                        for (let i = 1; i <= 12; i++) {
                            this.months[i] = 0;
                        }

                    } else {
                        for (let i = 1; i <= 12; i++) {
                            const month = `month_${i}`;
                            this.months[i] = budget[month];
                        }
                    }
                },

                setQuarterlyBudget(budget) {
                    if (!Object.keys(budget).length > 0) {
                        for (let i = 1; i <= 4; i++) {
                            this.quarters[i] = 0;
                        }

                    } else {
                        for (let i = 1; i <= 4; i++) {
                            this.quarters[i] = budget.quarterly[i];
                        }
                    }
                },
            },
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fandaonl/pointofsale.fanda.online/Modules/Accounting/Providers/../Resources/views/budget/index.blade.php ENDPATH**/ ?>