<?php $__env->startSection('title'); ?>
    <?php echo e(trans_choice('accounting::general.chart_of_account', 2), false); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('accounting::layouts.nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Content Header (Page header) -->
    <?php $__env->startComponent('accounting::components.section_header'); ?>
        <?php $__env->slot('title'); ?>
            <?php echo e(trans_choice('accounting::general.accounting', 1), false); ?>

        <?php $__env->endSlot(); ?>
        <?php $__env->slot('subtitle'); ?>
            <?php echo app('translator')->get('accounting::lang.view_charts_of_accounts'); ?>
        <?php $__env->endSlot(); ?>
    <?php echo $__env->renderComponent(); ?>

    <!-- Main content -->
    <section class="content no-print" id="vue-app">

        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('product.view')): ?>
            <div class="row">

                <?php $__env->startComponent('accounting::components.box'); ?>
                    <?php $__env->slot('header'); ?>
                        <div class="box-tools">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('accounting.chart_of_accounts.create')): ?>
                                <a href="<?php echo e(url('accounting/chart_of_account/create'), false); ?>" class="btn btn-primary">
                                    <i class="fas fa-plus"></i> <?php echo e(trans_choice('accounting::lang.add', 1), false); ?>

                                </a>
                            <?php endif; ?>
                        </div>
                    <?php $__env->endSlot(); ?>

                    <?php $__env->slot('body'); ?>
                        <!-- Main content -->
                        <section class="content">
                            <div class="card">
                                <div class="card-body p-0">
                                    <div class="table-responsive">
                                        <table id="data-table" class="table table-striped table-condensed table-hover">
                                            <thead>
                                                <tr>
                                                    <th><?php echo e(trans_choice('accounting::lang.action', 1), false); ?></th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.name', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::general.gl_code', 2), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.parent', 2), false); ?>

                                                        <?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

                                                        <?php echo e(trans_choice('accounting::lang.type', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::general.account_subtype', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.account', 1), false); ?>

                                                        <?php echo e(trans_choice('accounting::general.detail_type', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.active', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::general.manual_entries_allowed', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('accounting::lang.currency', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans_choice('account.opening_balance', 1), false); ?>

                                                    </th>
                                                    <th>
                                                        <?php echo e(trans('accounting::lang.current'), false); ?> <?php echo e(trans_choice('accounting::lang.balance', 1), false); ?>

                                                    </th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td>
                                                            <div class="btn-group">
                                                                <button href="#" class="btn btn-info dropdown-toggle btn-xs" data-toggle="dropdown"
                                                                    aria-expanded="false"><?php echo e(trans_choice('accounting::lang.action', 1), false); ?>

                                                                    <span class="caret"></span><span class="sr-only"></span>
                                                                </button>
                                                                <div class="dropdown-menu dropdown-menu-left">
                                                                    <a href="<?php echo e(url('accounting/chart_of_account/' . $key->id . '/show'), false); ?>"
                                                                        class="dropdown-item">
                                                                        <i class="fas fa-eye"></i>
                                                                        <span><?php echo e(trans_choice('accounting::lang.detail', 2), false); ?></span>
                                                                    </a>
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('accounting.chart_of_accounts.edit')): ?>
                                                                        <a href="<?php echo e(url('accounting/chart_of_account/' . $key->id . '/edit'), false); ?>"
                                                                            class="dropdown-item">
                                                                            <i class="fas fa-edit"></i>
                                                                            <span><?php echo e(trans_choice('accounting::lang.edit', 1), false); ?></span>
                                                                        </a>
                                                                    <?php endif; ?>
                                                                    <div class="dropdown-divider"></div>
                                                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('accounting.chart_of_accounts.destroy')): ?>
                                                                        <a href="<?php echo e(url('accounting/chart_of_account/' . $key->id . '/destroy'), false); ?>"
                                                                            class="dropdown-item confirm">
                                                                            <i class="fas fa-trash"></i>
                                                                            <span><?php echo e(trans_choice('accounting::lang.delete', 1), false); ?></span>
                                                                        </a>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </td>

                                                        <td>
                                                            <a href="<?php echo e(url('accounting/chart_of_account/' . $key->id . '/show'), false); ?>">
                                                                <span><?php echo e($key->name, false); ?></span> <i class="fas fa-external-link-alt"></i>
                                                            </a>
                                                        </td>

                                                        <td>
                                                            <span><?php echo e($key->gl_code, false); ?></span>
                                                        </td>

                                                        <td>
                                                            <span><?php echo e($key->parent->name, false); ?></span>
                                                        </td>

                                                        <td>
                                                            <?php if($key->account_type == 'asset'): ?>
                                                                <span><?php echo e(trans_choice('accounting::general.asset', 1), false); ?></span>
                                                            <?php elseif($key->account_type == 'expense'): ?>
                                                                <span><?php echo e(trans_choice('accounting::general.expense', 1), false); ?></span>
                                                            <?php elseif($key->account_type == 'equity'): ?>
                                                                <span><?php echo e(trans_choice('accounting::general.equity', 1), false); ?></span>
                                                            <?php elseif($key->account_type == 'liability'): ?>
                                                                <span><?php echo e(trans_choice('accounting::general.liability', 1), false); ?></span>
                                                            <?php elseif($key->account_type == 'income'): ?>
                                                                <span><?php echo e(trans_choice('accounting::general.income', 1), false); ?></span>
                                                            <?php endif; ?>
                                                        </td>

                                                        <td>
                                                            <span><?php echo e($key->account_subtype->name, false); ?></span>
                                                        </td>

                                                        <td>
                                                            <span><?php echo e($key->account_detail_type->name, false); ?></span>
                                                        </td>

                                                        <td>
                                                            <?php if($key->active == 1): ?>
                                                                <span
                                                                    class="label label-success btn-xs"><?php echo e(trans_choice('accounting::lang.yes', 1), false); ?></span>
                                                            <?php else: ?>
                                                                <span class="label label-danger btn-xs"><?php echo e(trans_choice('accounting::lang.no', 1), false); ?></span>
                                                            <?php endif; ?>
                                                        </td>

                                                        <td>
                                                            <?php if($key->allow_manual == 1): ?>
                                                                <span
                                                                    class="label label-success btn-xs"><?php echo e(trans_choice('accounting::lang.yes', 1), false); ?></span>
                                                            <?php else: ?>
                                                                <span class="label label-danger btn-xs"><?php echo e(trans_choice('accounting::lang.no', 1), false); ?></span>
                                                            <?php endif; ?>
                                                        </td>

                                                        <td>
                                                            <span><?php echo e($key->currency->code, false); ?></span>
                                                        </td>

                                                        <td>
                                                            <span><?php echo e($key->opening_balance, false); ?></span>
                                                        </td>

                                                        <td>
                                                            <span><?php echo e($key->current_balance, false); ?></span>
                                                        </td>

                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </section>
                    <?php $__env->endSlot(); ?>
                <?php echo $__env->renderComponent(); ?>

            </div>
        <?php endif; ?>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script>
        $(document).ready(function() {
            $('#data-table').DataTable();
        });
    </script>

    <script>
        var app = new Vue({
            el: "#vue-app",
            data: {
                records: <?php echo json_encode($data); ?>,
                selectAll: false,
                selectedRecords: []
            },
            methods: {
                // selectAllRecords() {
                //     this.selectedRecords = [];
                //     if (this.selectAll) {
                //         this.records.data.forEach(item => {
                //             this.selectedRecords.push(item.id);
                //         });
                //     }
                // },
            },
        })
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('accounting::layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/fandaonl/pointofsale.fanda.online/Modules/Accounting/Providers/../Resources/views/chart_of_account/index.blade.php ENDPATH**/ ?>